  bind pub o|o "!k" inchankick
  bind pub o|o "!kick" inchankick
  bind pub o|o "!kb" inchankb
  bind pub o|o "!ban" inchanban
  bind pub o|o "!perm" inchanban
  bind pub o|o "!unban" inchanunban
  bind pub o|o "!addserv" inchanaddserv
  bind pub o|o "!addbot" inchanaddbot
  bind pub o|o "!delserv" inchandelserv
  bind pub m "!deluser" inchandeluser
  bind pub m "!delbot" inchandeluser
  bind pub m "!addop" inchanaddop
  bind pub m "!chpass" inchanchpass
  bind pub m "!chattr" inchanchattr
  bind pub m "!addhost" inchanaddhost

#------------------------------------------------------------------------------------------------------------
# The following processes the !kb trigger command
#------------------------------------------------------------------------------------------------------------
proc inchankb {nick uhost hand chan rest} {
    global approved_chans
    set chan [string tolower $chan]
       set knick [lindex $rest 0]
       set reason [lrange $rest 1 end]
       if {[onchan $knick $chan] == 0} {
          puthelp "NOTICE $nick :I don't see $knick in this channel"
	  return 0
       }
       if [onchan $knick $chan] {
          if [isop $knick $chan] {
             puthelp "PRIVMSG $chan :$nick, It's not polite to kick ops, and *I'm* polite!"
	     return 0
	  }
          set mask [getmask $knick $chan]
	  putkick $chan $knick "$reason \(Banned\)"
          newchanban $chan $mask $nick "$reason \(by $nick\)..." "60"
	  return 0
       }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !k and !kick trigger commands
#------------------------------------------------------------------------------------------------------------
proc inchankick {nick uhost hand chan rest} {
    global approved_chans
    set chan [string tolower $chan]
       set knick [lindex $rest 0]
       set reason [lrange $rest 1 end]
       if {[onchan $knick $chan] == 0} {
          puthelp "NOTICE $nick :I don't see $knick in this channel"
	  return 0
       }
       if [onchan $knick $chan] {
          if [isop $knick $chan] {
             puthelp "PRIVMSG $chan :$nick, It's not polite to kick ops, and *I'm* polite!"
	     return 0
	  }
          putkick $chan $knick "$reason"
       }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !ban and !perm trigger commands
#------------------------------------------------------------------------------------------------------------
proc inchanban {nick uhost hand chan rest} {
    global approved_chans
    set chan [string tolower $chan]
       set knick [lindex $rest 0]
       set reason [lrange $rest 1 end]
       if {[onchan $knick $chan] == 0} {
          if [string match "*!*@*" $knick] {
	    if [string match "\\*!\\*@\\*" $knick] {
              puthelp "PRIVMSG $chan :You just tried to perm ban the whole channel!!"
	      return 0
	    }
#            set knick [string trimleft [$knick] *!]
#            set knick *!*$knick
	    newchanban $chan $knick $nick "$reason \(by $nick\)..." "0"
            puthelp "NOTICE $nick :Host $knick is now perm banned"
	    return 0
	  } else {
	    puthelp "NOTICE $nick :I don't see $knick in this channel"
	    return 0
	  }
       }
       if [onchan $knick $chan] {
          if [isop $knick $chan] {
             puthelp "PRIVMSG $chan :C'mon $nick, I'm not gunna ban an op, that's just mean!"
	     return 0
	  }
          set mask [getmask $knick $chan]
	  putkick $chan $knick "$reason \(Perm Banned\)"
          newchanban $chan $mask $nick "$reason \(by $nick\)..." "0"
	  return 0
       }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !unban trigger command
#------------------------------------------------------------------------------------------------------------
proc inchanunban {nick uhost hand chan rest} {
    global approved_chans
    set chan [string tolower $chan]
       set knick [lindex $rest 0]
          if [string match "*!*@*" $knick] {
#            set knick [string trimleft [$knick] *!]
#            set knick "*!*$knick"
            foreach activeban [banlist $chan] {
	    if {[lindex $activeban 0] == $knick} {
              killchanban $chan $knick
	      pushmode $chan -b $knick
              puthelp "NOTICE $nick :Host $knick is now un-banned from the channel"
	      return 0
	    }
	    }
            if [ischanban $knick $chan] {
	      pushmode $chan -b $knick
              puthelp "NOTICE $nick :Host $knick is now un-banned from the channel"
	    } else {
   	      puthelp "NOTICE $nick :I don't see $knick in the ban list"
	      return 0
	    }
	  }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !addserv trigger command
#------------------------------------------------------------------------------------------------------------
proc inchanaddserv {nick uhost hand chan rest} {
  global approved_chans
    set chan [string tolower $chan]
      set knick [lindex $rest 0]
      if {![onchan $knick $chan]} {
        puthelp "NOTICE $nick :I don't see $knick in this channel"
	return 0
      } else {
        if [validuser [nick2hand $knick]] {
          puthelp "NOTICE $nick :$knick is already on the bots, adding +v"
          set mask [getmask $knick $chan]
	  setuser [nick2hand $knick] HOSTS $mask
	  chattr [nick2hand $knick] +v
	  return 0
	} else {
          set mask [getmask $knick $chan]
	  adduser $knick $mask
	  chattr $knick -hopfmnx
	  chattr $knick +v
	  puthelp "NOTICE $nick :Adding $knick to the auto +v list."
	  return 0
	}
      }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !addbot trigger command
#------------------------------------------------------------------------------------------------------------
proc inchanaddbot {nick uhost hand chan rest} {
  global approved_chans
    set chan [string tolower $chan]
      set knick [lindex $rest 0]
      if {![onchan $knick $chan]} {
        puthelp "NOTICE $nick :I don't see $knick in this channel"
	return 0
      } else {
        if [validuser [nick2hand $knick]] {
          puthelp "NOTICE $nick :$knick is already on the bots, adding +vf"
          set mask [getmask $knick $chan]
	  setuser [nick2hand $knick] HOSTS $mask
	  chattr [nick2hand $knick] +vfb $chan
	  setuser [nick2hand $knick] PASS "SDgtgfdfsdde23d34d3"
	  return 0
	} else {
          set mask [getmask $knick $chan]
	  adduser $knick $mask
	  chattr $knick -hopmnx
	  chattr $knick +vfb $chan
	  setuser [nick2hand $knick] PASS "SDgtgfdfsdde23d34d3"
	  puthelp "NOTICE $nick :Adding $knick to the auto +vf bot list."
	  return 0
	}
      }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !delserv trigger command
#------------------------------------------------------------------------------------------------------------
proc inchandelserv {nick uhost hand chan rest} {
  global approved_chans
    set chan [string tolower $chan]
      set knick [lindex $rest 0]
        if [validuser $knick] {
	  if [matchattr $knick +o] {
            puthelp "NOTICE $nick :$knick is an OP not an FTP site!  Nice try, tho."
  	    return 0
 	  } else {
	    deluser $knick
            putserv "MODE $chan -ov $knick $knick"
            puthelp "NOTICE $nick :$knick has been successfully removed from the bots."
	    return 1
	  }
	} else {
          puthelp "NOTICE $nick :$knick is not a valid user.."
	}
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !addop trigger command
#------------------------------------------------------------------------------------------------------------
proc inchanaddop {nick uhost hand chan rest} {
  global approved_chans botnick
    set chan [string tolower $chan]
    set opchan [string tolower [lindex $rest 1]]
      if {[string match "global" $opchan] || [string match "" $opchan]} {
      set knick [lindex $rest 0]
      if {![onchan $knick $chan]} {
        puthelp "NOTICE $nick :I don't see $knick in this channel"
	return 0
      } else {
        if [validuser [nick2hand $knick]] {
          set mask [getmask $knick $chan]
	  setuser [nick2hand $knick] HOSTS $mask
	  chattr [nick2hand $knick] +hopf
          puthelp "NOTICE $nick :$knick is already on the bots, added +o"
	  return 0
	} else {
          set mask [getmask $knick $chan]
	  adduser $knick $mask
	  chattr $knick +hopf
	  puthelp "NOTICE $nick :Added $knick as our newest op! Welcome $knick!"
	  puthelp "NOTICE $knick :Please set a password using: /msg $botnick pass <password>"
	  return 1
	}
      }
      } elseif {[string match "channel" $opchan]} {
      set knick [lindex $rest 0]
      if {![onchan $knick $chan]} {
        puthelp "NOTICE $nick :I don't see $knick in this channel"
	return 0
      } else {
        if [validuser [nick2hand $knick]] {
          set mask [getmask $knick $chan]
	  setuser [nick2hand $knick] HOSTS $mask
	  chattr [nick2hand $knick] +hopf $chan
          puthelp "NOTICE $nick :$knick is already on the bots, added +o"
	  return 0
	} else {
          set mask [getmask $knick $chan]
	  adduser $knick $mask
	  chattr $knick +hopf $chan
	  puthelp "NOTICE $nick :Added $knick as our newest channel op! Welcome $knick!"
	  puthelp "NOTICE $knick :Please set a password using: /msg $botnick pass <password>"
	  return 1
	}
      }
      } else {
        puthelp "NOTICE $nick :Syntax: !addop <nick> \[global/channel\]"
	return 0
      } 
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !deluser trigger command
#------------------------------------------------------------------------------------------------------------
proc inchandeluser {nick uhost hand chan rest} {
  global approved_chans
    set chan [string tolower $chan]
      set knick [lindex $rest 0]
        if [validuser $knick] {
	    deluser $knick
            putserv "MODE $chan -ov $knick $knick"
            puthelp "NOTICE $nick :$knick has been successfully removed from the bots."
	    return 1
	} else {
          puthelp "NOTICE $nick :$knick is not a valid user.."
        }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !chpass trigger command
#------------------------------------------------------------------------------------------------------------
proc inchanchpass {nick uhost hand chan rest} {
  global approved_chans botnick
    set chan [string tolower $chan]
      set knick [lindex $rest 0]
      if {![onchan $knick $chan]} {
        puthelp "NOTICE $nick :I don't see $knick in this channel"
	return 0
      } else {
        if [validuser [nick2hand $knick]] {
          puthelp "NOTICE $nick :Resetting $knick's password"
	  setuser [nick2hand $knick] PASS ""
	  puthelp "NOTICE $knick :Please set a password using: /msg $botnick pass <password>"
	  return 0
	} else {
	  puthelp "NOTICE $nick :$knick is not a valid user."
	  return 0
	}
      }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !addhost trigger command
#------------------------------------------------------------------------------------------------------------
proc inchanaddhost {nick uhost hand chan rest} {
  global approved_chans
    set chan [string tolower $chan]
      set knick [lindex $rest 0]
      set mask [lrange $rest 1 end]
      if {![onchan $knick $chan]} {
        puthelp "NOTICE $nick :I don't see $knick in this channel"
	return 0
      } else {
        if [validuser $knick] {
          if [string match "*!*@*" $mask] {
	    if [string match "\\*!\\*@\\*" $mask] {
              puthelp "PRIVMSG $nick :Don't think so buddy!!"
	      return 0
	    }
	    if {[string match "*!*@\\*" $mask] == 1 || [string match "*!\\*@*" $mask] == 1} {
              puthelp "PRIVMSG $nick :Host is too broad, please be more specific"
	      return 0
	    }
	    setuser $knick HOSTS $mask
            puthelp "NOTICE $nick :$knick's new hostmask has been added"
	    puthelp "NOTICE $knick :Your new hostmask has been added"
	    return 0
	  }
          puthelp "NOTICE $nick :Attempting to add $knick's new hostmask"
          set mask [getmask $knick $chan]
	  setuser $knick HOSTS $mask
	  puthelp "NOTICE $knick :Your new hostmask has been added"
	  return 0
	} else {
	  puthelp "NOTICE $nick :$knick is either not a valid user, or is known as something else."
	  return 0
	}
      }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !chattr trigger command
#------------------------------------------------------------------------------------------------------------
proc inchanchattr {nick uhost hand chan rest} {
  global approved_chans
    set chan [string tolower $chan]
      set knick [lindex $rest 0]
      set attr [lrange $rest 1 end]
      if {![onchan $knick $chan]} {
        puthelp "NOTICE $nick :I don't see $knick in this channel"
	return 0
      } else {
        if {[string match "*n*" $attr] || [string match "*x*" $attr] || [string match "*m*" $attr]} {
		if {[matchattr $hand n] == 0} {
			puthelp "NOTICE $nick :Only owners can set +n, +m or +x!"
			return 0
		}
	}
        if [validuser [nick2hand $knick]] {
          puthelp "NOTICE $nick :Changing $knick's attributes to $attr"
	  chattr [nick2hand $knick] $attr
	  return 0
	} else {
	  puthelp "NOTICE $nick :$knick is not a valid user."
	  return 0
	}
      }
}

