# Val_SubOp 1.1 by THE VALHERU (valheru@gmx.net)
#
# This is a modified version of SubOp 5.3.0 - Released by MHT & YaZZ
#
# Many thanks to Brikko <brikko@hotmail.com>
# Based on Hal Danziger's first release.
#
# tested on eggdrop 1.4.3 and 1.4.4
#
#####
#
# flag V - subop flag (local and/or global flag)
#
# .quick <nick> [reason]			- 8 seconds ban nick (anti auto-rejoin)
# .banip <nick> [reason]			- 1 hour ban on IP of nick
# .disableban <ban#> <delay>			- disable a ban for <delay> minutes
#
# !kick  <nick> [reason]			- kick nick
# !quick <nick> [reason]			- 8 seconds ban nick (anti auto-rejoin)
# !banip <nick> [reason]			- 1 hour ban on IP of nick
# !kban  <nick> [reason]			- 1 hour ban nick
# !pkban <nick> [reason]			- permanent ban nick
# !unban <mask>					- unban mask
# !topic <topic>				- change topic
#
# /msg <botnick> subop <channel> <pass>		- pushmode +v to subop
#
# Set your Subops with flag +V
# SubOps, and Ops are allowed to kick, quick, kickban, banip, and topic
# but SubOps can't kick or ban bots, ops and masters.
# important: Ops are NOT protected until they get their +o
#
# note: proc strictmaskhost avoids a bug of maskhost with strict-host set to 0
#       
#
#####
#
# history:
# --------
# 1.0 -Added that Subops can't attack local/global +f users
#     -Added that Subops can't perform commands on themselves
#      (some think its a fun to kick themselves)
# 1.1 - Added logging of supop actions in file "subop.actions.log"
#
#####

# some commands are disabled by deafult, remove the # to reactivate them

bind msg  V|V subop     msg:so_voice
bind msg  V|V subopme   msg:so_voice

bind pub - !kick        pub:so_kick
bind pub - !kban        pub:so_kban
bind pub - !quick       pub:so_quick
bind pub - !banip       pub:so_banip
# bind pub - !pkban       pub:so_pkban
# bind pub - !unban       pub:so_unban
# bind pub - !topic       pub:so_topic

#bind dcc o|o quick      dcc:so_quick
#bind dcc o|o banip      dcc:so_banip
#bind dcc o|o disableban dcc:so_disableban



#----------------- DON'T EDIT BELOW ------------------------------------------

############################################################
set quicktime 8
set quickchannel ""
set quicktarget ""
set quickwait 0
###########################################################
proc logaction {handle command channel target} {

	set tgthost [getchanhost $target $channel]
	set tgthandle [nick2hand $target $channel]
	set action_time [ctime [unixtime]]
	
	set fd [open subop.actions.log a+]
	puts $fd "$channel : $handle $command $target $tgthandle $tgthost $action_time" 
	close $fd


}


############################################################
proc strictmaskhost {nick channel} {
    global {strict-host}
    
    set banmask [maskhost [getchanhost $nick $channel]]
    if {${strict-host} == 0} {
	set banmask [format "*!*%s" [string range $banmask 2 [string length $banmask]]]
    }
    return $banmask
}

############################################################
proc msg:so_voice {nick uhost handle arg} {
    global botnick

    set channel [lindex $arg 0]
    set pass [lindex $arg 1]
    if {$pass == ""} {
	puthelp "NOTICE $nick :usage: /msg $botnick subop <channel> <pass>"
	return
    }
    if {[passwdok $handle $pass]} {
	putlog "($nick!$uhost) !$handle! SubOp"
	pushmode $channel +v $nick
    } else {
	putlog "($nick!$uhost) !$handle! failed SubOp"
    }
}

############################################################
proc so_validtarget {cmd nick handle target channel} {
    global botnick
    
    if {![onchan $target $channel]} {
	puthelp "NOTICE $nick :$target is not on $channel"
	return 0
    }

    if {[string tolower $target] == [string tolower $nick]} {return 0} 
   
    if {[string tolower $target] == [string tolower $botnick]} {
	putlog "!$nick!$handle! tried to $cmd me."
	putserv "KICK $channel $nick :Don't even think about it..."
	return 0
    }

    set handtgt [nick2hand $target $channel]

    if { ([matchattr $handtgt b]) } {
	putlog "$nick!$handle! tried to $cmd $target, but $target is a BOT"
	puthelp "NOTICE $nick :$target is a BOT and cannot be ${cmd}ed."
	return 0
    }

    if { ([matchattr $handtgt f|f $channel]) && ([isvoice $target $channel]) } {
	puthelp "NOTICE $nick :$target is PROTECTED and cannot be ${cmd}ed."
	putlog "$nick!$handle! tried to $cmd $target, but $target is PROTECTED"
	return 0
    }

	
    if { [so_IsValidOperator $nick $handle $channel] } { return 1 }
    if { [so_IsValidSubOp $nick $handle $channel] } {
	if { ![so_IsValidOperator $target $handtgt $channel] } { 
	    return 1 
	}
	putlog "!$nick!$handle! tried to $cmd $target, but $target is +o"
	puthelp "NOTICE $nick :$target cannot be ${cmd}ed."
    } 
    return 0
}

####
proc so_IsValidOperator {nick handle channel}  {
    if { ([isop $nick $channel]) && (([matchattr $handle o|o $channel]) || ([matchattr $handle m|m $channel])) } { return 1 }
	return 0
}

####
proc so_IsValidSubOp {nick handle channel} {
    if { ([isvoice $nick $channel]) && ([matchattr $handle V|V $channel]) } { return 1 }
    return 0
}


############################################################
proc pub:so_kick {nick uhost handle channel arg} {
    if {![validuser $handle]} { return 0 }
    set target [lindex $arg 0]
    set reason [lrange $arg 1 end]

    if {[so_validtarget "kick" $nick $handle $target $channel]} {
	if {$reason == ""} { set reason "Requesting." }
	putserv "KICK $channel $target :${nick}:$reason"
	logaction $handle "kick" $channel $target
	puthelp "NOTICE $nick :Your action was logged for review."
	return 1
    }
    return 0
}

############################################################
proc pub:so_banip {nick uhost handle channel arg} {
    if {![validuser $handle]} { return 0 }
    set target [lindex $arg 0]
    set reason [lrange $arg 1 end]
    
    if {[so_validtarget "banip" $nick $handle $target $channel]} {
	set uhost [getchanhost $target $channel]
	set banmask "*!*[string range $uhost [string first "@" $uhost] end]"
	if {$reason == ""} { set reason "Requesting." }
	newchanban $channel $banmask $nick $reason 60
	putserv "KICK $channel $target :${nick}: $reason"
	logaction $handle "banip" $channel $target
	puthelp "NOTICE $nick :Your action was logged for review."
	return 1
    }
    return 0
}

############################################################
proc dcc:so_banip {handle idx arg} {
    global botnick
    set channel [lindex [console $idx] 0]
    set target [lindex $arg 0]
    set reason [lrange $arg 1 end]
    
    if {$target == ""} {
	putdcc $idx "Usage: banip <nick> \[reason\]"
    } elseif {![onchan $target $channel]} {
	putdcc $idx "$target is not on $channel"
    } elseif {([string tolower $target] == [string tolower $botnick]) || ([matchattr $target b])} {
	putdcc $idx "$target is a bot"
    } elseif {[so_IsValidOperator $target [nick2hand $target $channel] $channel]} {
	putdcc $idx "$target is +o on $channel"
    } else {
	set uhost [getchanhost $target $channel]
	set banmask "*!*[string range $uhost [string first "@" $uhost] end]"
	if {$reason == ""} { set reason "Requesting." }
	newchanban $channel $banmask $handle $reason 60
	putserv "KICK $channel $target :$reason"
    }
    return 1
}

############################################################
proc pub:so_kban {nick uhost handle channel arg} {
    global {ban-time}
    if {![validuser $handle]} { return 0 }
    set target [lindex $arg 0]
    set reason [lrange $arg 1 end]

    if {[so_validtarget "kban" $nick $handle $target $channel]} {
	newchanban $channel [strictmaskhost $target $channel] $nick $reason ${ban-time}
	if {$reason == ""} { set reason "Requesting." }
	putserv "KICK $channel $target :${nick}: $reason"
	logaction $handle "kban" $channel $target
	puthelp "NOTICE $nick :Your action was logged for review."
	return 1
    }
    return 0
}

############################################################
proc pub:so_pkban {nick uhost handle channel arg} {
    if {![validuser $handle]} { return 0 }
    set target [lindex $arg 0]
    set reason [lrange $arg 1 end]

    if {[so_validtarget "pkban" $nick $handle $target $channel]} {
	newchanban $channel [strictmaskhost $target $channel] $nick $reason 0
	if {$reason == ""} { set reason "Requesting." }
	putserv "KICK $channel $target :${nick}: $reason"
	logaction $handle "pkban" $channel $target
	puthelp "NOTICE $nick :Your action was logged for review."
	return 1
    }
    return 0
}

############################################################
proc pub:so_unban {nick uhost handle channel mask} {
    if {![validuser $handle]} { return 0 }
    
    if {([so_IsValidOperator $nick $handle $channel]) || ([so_IsValidSubOp $nick $handle $channel])} {
	if {([killchanban $channel $mask]) || ([killban $mask])} {
	    return 1
	}
	puthelp "NOTICE $nick :unban - invalid mask $mask"
    }
    return 0
}

############################################################
proc pub:so_topic {nick uhost handle channel topic} {
    if {![validuser $handle]} { return 0 }
    
    if {([so_IsValidOperator $nick $handle $channel]) || ([so_IsValidSubOp $nick $handle $channel])} {
	putserv "TOPIC $channel :$topic"
	return 1
    }
    return 0
}

############################################################
proc pub:so_quick {nick uhost handle channel arg} {
    global quickwait quicktime quickchannel quicktarget
    if {![validuser $handle]} { return 0 }
    if {$quickwait == 1} {
        puthelp "NOTICE $nick :One Quick on time..."
        return 0
    }
    set target [lindex $arg 0]
    set reason [lrange $arg 1 end]
    
    if {[so_validtarget "quick" $nick $handle $target $channel]} {
        if {$reason == ""} { set reason "Requesting." }
        putserv "MODE $channel -o+b $target $target"
        putserv "KICK $channel $target :${nick}:\[QuickBan $quicktime sec.\] $reason"
        set quickwait 1
        set quickchannel $channel
        set quicktarget $target
        utimer $quicktime so_quickfree
        logaction $handle "quick" $channel $target
        puthelp "NOTICE $nick :Your action was logged for review."
        return 1
    }
    return 0
}

############################################################
proc dcc:so_quick {handle idx arg} {
    global quickwait quicktime quickchannel quicktarget botnick
    if {$quickwait == 1} {
        putdcc $idx "One Quick on time..."
        return 0
    }
    set channel [lindex [console $idx] 0]
    set target [lindex $arg 0]
    set reason [lrange $arg 1 end]
    
    if {$target == ""} {
	putdcc $idx "Usage: quick <nick> \[reason\]"
    } elseif {![onchan $target $channel]} {
	putdcc $idx "$target is not on $channel"
    } elseif {([string tolower $target] == [string tolower $botnick]) || ([matchattr $target b])} {
	putdcc $idx "$target is a bot"
    } elseif {[so_IsValidOperator $target [nick2hand $target $channel] $channel]} {
	putdcc $idx "$target is +o on $channel"
    } else {
        if {$reason == ""} { set reason "Requesting." }
        putserv "MODE $channel -o+b $target $target"
        putserv "KICK $channel $target :\[QuickBan $quicktime sec.\] $reason"
        set quickwait 1
        set quickchannel $channel
        set quicktarget $target
        utimer $quicktime so_quickfree
    }
    return 1
}

############################################################
proc so_quickfree {} {
    global quickwait quickchannel quicktarget
    puthelp "MODE $quickchannel -b $quicktarget"
    puthelp "NOTICE $quicktarget :Quick Ban on $quickchannel ended!"
    set quickwait 0
}


############################################################
proc dcc:so_disableban {hand idx arg} {
    set bannum [lindex $arg 0]
    set disabledelay [lindex $arg 1]
    if { ($bannum == "") || ($disabledelay == "") } { 
	putdcc $idx "Usage: .disableban <ban#> <delay>"
	return 0 
    }
    
    set bannum [expr $bannum - 1]
    set bans [banlist]
    set count [llength $bans]
    set res 0
    if { [set banentry [lindex $bans $bannum]] != "" } {
	if { [set res [killban [lindex $banentry 0]]] } {
	    timer $disabledelay "newban [lindex $banentry 0] [lindex $banentry 5] \"[lindex $banentry 1]\" [lindex $banentry 2]"
	    putlog "#$hand# disableban [lindex $banentry 0] for $disabledelay minutes"
	}
    } 
    if { !$res } {
	putdcc $idx "disableban: Unable to locate ban in global ban entries"
    }
}

############################################################
putlog "VAL SubOp 1.1 loaded"

####
